/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

import intrinsic.Function;
import intrinsic.flash.display.DisplayObject;
import intrinsic.mx.core.*;
import intrinsic.mx.events.ScrollEvent;
import intrinsic.mx.events.ScrollEventDirection;

public abstract class Scrollable extends Control {
	ScrollBar horizontalBar, verticalBar;

Scrollable () {
}
	
public Scrollable (Composite parent, int style) {
	super (parent, style);
}

boolean checkComponent(DisplayObject component) {
	if (object == component) return false;
	if (verticalBar != null && verticalBar.getBar() == component) return false;
	if (horizontalBar != null && horizontalBar.getBar() == component) return false;
	return true;
}

public Point computeSize (int wHint, int hHint, boolean changed) {
	checkWidget ();
	Point size = super.computeSize (wHint, hHint, changed);
	Rectangle trim = computeTrim (0, 0, size.x, size.y); 
	return new Point (trim.width, trim.height);
}

public Rectangle computeTrim (int x, int y, int width, int height) {
	checkWidget ();
	EdgeMetrics view;
	if (object instanceof ScrollControlBase) {
		ScrollControlBase scroll = (ScrollControlBase)object;
		view = scroll.viewMetrics;
		if (verticalBar != null  && scroll.verticalScrollPolicy == ScrollPolicy.OFF) {
			width += intrinsic.mx.controls.scrollClasses.ScrollBar.THICKNESS;
		}
		if (horizontalBar != null && scroll.horizontalScrollPolicy == ScrollPolicy.OFF) {
			height += intrinsic.mx.controls.scrollClasses.ScrollBar.THICKNESS;
		}
	} else if (object instanceof Container){
		view = ((Container)object).viewMetricsAndPadding;
	} else {
		view = new EdgeMetrics();
	}
	x -= view.left;
	y -= view.top;
	width += (view.left + view.right);
	height += (view.top + view.bottom);
	return new Rectangle(x, y, width, height);
}

ScrollBar createScrollBar (int type) {
	ScrollBar bar = new ScrollBar (this, type);
	if ((state & CANVAS) != 0) {
		bar.setValues(0, 0, 100, 10, 1, 10);
	}
	return bar;
}

void createWidget () {
	super.createWidget ();
	if ((style & SWT.H_SCROLL) != 0) horizontalBar = createScrollBar (SWT.H_SCROLL);
	if ((style & SWT.V_SCROLL) != 0) verticalBar = createScrollBar (SWT.V_SCROLL);
}

public Rectangle getClientArea () {
	checkWidget ();
	UIComponent topComponent = topComponent();
	double width = topComponent.width, height = topComponent.height;
	EdgeMetrics view;
	if (object instanceof ScrollControlBase) {
		ScrollControlBase scroll = (ScrollControlBase)object;
		view = scroll.viewMetrics;
	} else if (object instanceof Container){
		view = ((Container)object).viewMetricsAndPadding;
	} else {
		view = new EdgeMetrics();
	}
	width -= (view.left + view.right);
	height -= (view.top + view.bottom);
	return new Rectangle(0, 0, (int)width, (int)height);
}

public ScrollBar getHorizontalBar () {
	checkWidget ();
	return horizontalBar;
}

public ScrollBar getVerticalBar () {
	checkWidget ();
	return verticalBar;
}

boolean hasBorder () {
	return (style & SWT.BORDER) != 0;
}

void hookEvents () {
	super.hookEvents ();
	if (object instanceof ScrollControlBase) {
		object.addEventListener(ScrollEvent.SCROLL, scrollHandlerFunction ());
	}
}

void scrollHandler (ScrollEvent event) {
	if (event.direction == ScrollEventDirection.HORIZONTAL) {
		if (horizontalBar != null) horizontalBar.scrollHandler(event);
	} else {
		if (verticalBar != null) verticalBar.scrollHandler(event);		
	}
}

native Function scrollHandlerFunction ()/*{
	return scrollHandler__Lmx_events_ScrollEvent_2;
}*/;

void releaseChildren (boolean destroy) {
	if (horizontalBar != null) {
		horizontalBar.release (false);
		horizontalBar = null;
	}
	if (verticalBar != null) {
		verticalBar.release (false);
		verticalBar = null;
	}
	super.releaseChildren (destroy);
}

}
